unit DirectoryOpusViewerPlugins;

interface

uses
  SysUtils, Classes, Windows, Controls, Messages;

// VIEWERPLUGININFO flags  
const
  DVPFIF_CanHandleStreams		= $00000001;	// Plugin can handle IStreams to identify and read files
  DVPFIF_CanHandleBytes			= $00000002;	// Plugin can identify files based on file header
  DVPFIF_CatchAll			    = $00000004;	// 'Catch All' plugin wants to be called last
  DVPFIF_DefaultCatchAll		= $00000008;	// 'Default Catch All' plugin is last unless there's another 'catch all'
  DVPFIF_ExtensionsOnly			= $00000010;	// Plugin only wants to identify files based on file extension
  DVPFIF_ExtensionsOnlyIfSlow	= $00000020;	// Plugin looks only at file extensions if file is 'slow'
  DVPFIF_ExtensionsOnlyIfNoRndSeek	= $00000040;	// Plugin looks only at file extensions if file doesn't support random seeking
  DVPFIF_ExtensionsOnlyForThumbnails = $00000080;	// Plugin looks only at file extensions if generating thumbnails
  DVPFIF_NoSlowFiles			= $00000100;	// Plugin doesn't handle 'slow' files
  DVPFIF_NeedRandomSeek			= $00000200;	// Plugin needs random seek capability
  DVPFIF_CanConfigure			= $00000400;	// Plugin has a configuration interface
  DVPFIF_CanShowAbout			= $00000800;	// Plugin has an About function
  DVPFIF_NoThumbnails			= $00001000;	// Plugin doesn't want to be called to generate thumbnails
  DVPFIF_NoProperties			= $00002000;	// Don't show 'Properties' item on default context menu
  DVPFIF_ZeroBytesOk			= $00004000;	// Zero byte files are ok (eg text files)
  DVPFIF_OverrideInternal		= $00008000;	// Plugin can override internal Opus image routines
  DVPFIF_NoMultithreadThumbnails	= $00080000;	// Don't call simultaneously on multiple threads for thumbnails // added by ST

// Plugin major types
type
  TDOpusViewerPluginFileType = (DVPMajorType_Image, DVPMajorType_Sound,	DVPMajorType_Text, DVPMajorType_Other);

type
  TDOpusViewerPluginInfoW = record
    cbSize: UINT;					// Structure size
    dwFlags: DWORD;					// Flags
    dwVersionHigh: DWORD;				// Version (high)
    dwVersionLow: DWORD;				// Version (low)
    lpszHandleExts: LPWSTR;				// File extensions the plugin handles, eg ".xxx;.yyy;.zzz"
    lpszName: LPWSTR;					// Plugin primary file format name, eg "JPEG"
    lpszDescription: LPWSTR;				// Plugin description string, eg "Directory Opus JPEG Viewer"
    lpszCopyright: LPWSTR;				// Copyright string, eg "(c) 2001 GP Software"
    lpszURL: LPWSTR;					// Reference URL, eg "http://www.gpsoft.com.au"
    cchHandleExtsMax: UINT;				// Max. length of buffer
    cchNameMax: UINT;					// Max. length of buffer
    cchDescriptionMax: UINT;				// Max. length of buffer
    cchCopyrightMax: UINT;				// Max. length of buffer
    cchURLMax: UINT;					// Max. length of buffer
    dwlMinFileSize: DWORDLONG;				// Minimum size of file that we handle
    dwlMaxFileSize: DWORDLONG;				// Maximum size of file that we handle
    dwlMinPreviewFileSize: DWORDLONG;			// Minimum size of file that we handle in preview mode
    dwlMaxPreviewFileSize: DWORDLONG;			// Maximum size of file that we handle in preview mode
    uiMajorFileType: TDOpusViewerPluginFileType;        // Primary type of file this plugin handles
    idPlugin: TGUID;					// Unique identifier for this plugin
  end;

// VIEWERPLUGINFILEINFO flags
const
  DVPFIF_CanReturnBitmap		= $00000001;	// We can return a bitmap for this file type
  DVPFIF_CanReturnViewer		= $00000002;	// We can create a viewer for this file type
  DVPFIF_CanReturnThumbnail		= $00000004;	// We can return a thumbnail for this filetype (in bitmap form)
  DVPFIF_CanShowProperties		= $00000008;	// We can show a Properties dialog for this file

type
  LPSIZE = ^TtagSIZE;
  TtagSIZE = record
    cx: Integer;
    cy: Integer;
  end;
    
type
  TLPVIEWERPLUGINFILEINFOW = record
    cbSize: UINT;
    dwFlags: DWORD;
    wMajorType: WORD;
    wMinorType: WORD;
    szImageSize: TtagSIZE;
    iNumBits: Integer;
    lpszInfo: LPWSTR;
    cchInfoMax: UINT;
    dwPrivateData: Array[0..7] of DWORD;
  end;

// dwFlags for the CreateViewer function
const
  DVPCVF_Border				= $00000001;	// Create viewer window with a border
  DVPCVF_Preview			= $00000002;	// Viewer is being used for the Lister View Pane
  DVPCVF_ReturnTabs			= $00000004;	// Pass tab keypresses (via NM_KEYDOWN message) to parent window


// Messages sent to a plugin viewer window
const
  DVPLUGINMSG_BASE          = WM_APP + $f00;
  DVPLUGINMSG_LOADA         = DVPLUGINMSG_BASE + 1;     // Load picture (lParam = LPSTR lpszName)
  DVPLUGINMSG_LOADW         = DVPLUGINMSG_BASE + 2;		// Load picture (lParam = LPWSTR lpszName)
  DVPLUGINMSG_LOADSTREAMA   = DVPLUGINMSG_BASE + 3;		// Load picture (wParam = LPSTR lspzName, lParam = LPSTREAM lpStream)
  DVPLUGINMSG_LOADSTREAMW   = DVPLUGINMSG_BASE + 4;		// Load picture (wParam = LPWSTR lspzName, lParam = LPSTREAM lpStream)
  DVPLUGINMSG_GETIMAGEINFOA = DVPLUGINMSG_BASE + 5;		// Get info for loaded picture (lParam = LPVIEWERPLUGINFILEINFOA)
  DVPLUGINMSG_GETIMAGEINFOW = DVPLUGINMSG_BASE + 6;		// Get info for loaded picture (lParam = LPVIEWERPLUGINFILEINFOW)
  DVPLUGINMSG_GETCAPABILITIES = DVPLUGINMSG_BASE + 7;	// Get viewer capabilities
  DVPLUGINMSG_RESIZE        = DVPLUGINMSG_BASE + 8;		// Resize window (wParam = DWORD left,top lParam = DWORD width, height )
  DVPLUGINMSG_SETROTATION   = DVPLUGINMSG_BASE + 9;		// Set initial rotation ( wParam = int rotate_angle )
  DVPLUGINMSG_ROTATE        = DVPLUGINMSG_BASE + 10;	// Rotate image ( wParam = int rotate_amount )
  DVPLUGINMSG_SETZOOM       = DVPLUGINMSG_BASE + 11;	// Set initial zoom ( wParam = int zoom_factor )
  DVPLUGINMSG_ZOOM          = DVPLUGINMSG_BASE + 12;	// Zoom image (wParam = int zoom_factor )
  DVPLUGINMSG_GETZOOMFACTOR = DVPLUGINMSG_BASE + 13;	// Get current zoom factor
  DVPLUGINMSG_SELECTALL     = DVPLUGINMSG_BASE + 14;	// Select contents
  DVPLUGINMSG_TESTSELECTION = DVPLUGINMSG_BASE + 15;	// Is there a selection?
  DVPLUGINMSG_COPYSELECTION = DVPLUGINMSG_BASE + 16;	// Copy selection to clipboard
  DVPLUGINMSG_PRINT         = DVPLUGINMSG_BASE + 17;	// Print picture
  DVPLUGINMSG_PROPERTIES    = DVPLUGINMSG_BASE + 18;	// Show properties dialog ( wParam = HWND hWndParent )
  DVPLUGINMSG_REDRAW        = DVPLUGINMSG_BASE + 19;	// Redraw (if wParam = TRUE it means the background colour has changed and is supplied in lParam )
  DVPLUGINMSG_GETPICSIZE    = DVPLUGINMSG_BASE + 20;	// Return size of current image (wParam = LPINT lpiNumBits (optional), lParam = LPSIZE)
  DVPLUGINMSG_GETAUTOBGCOL  = DVPLUGINMSG_BASE + 21;	// Return 'automatic' background colour based on image
  DVPLUGINMSG_MOUSEWHEEL    = DVPLUGINMSG_BASE + 22;	// Mouse wheel message
  DVPLUGINMSG_ADDCONTEXTMENUA = DVPLUGINMSG_BASE + 23;	// Add items to context menu ( wParam = LPDWORD numItems, result = LPDVPCONTEXTMENUITEMA array)
  DVPLUGINMSG_ADDCONTEXTMENUW = DVPLUGINMSG_BASE + 24;	// Add items to context menu ( wParam = LPDWORD numItems, result = LPDVPCONTEXTMENUITEMW array)
  DVPLUGINMSG_SETABORTEVENT = DVPLUGINMSG_BASE + 25;	// Provides an event that is set to abort the loading of a file ( lParam = HANDLE )
  DVPLUGINMSG_GETORIGINALPICSIZE = DVPLUGINMSG_BASE + 26;	// Return original size of current image (wParam = LPINT lpiNumBits (optional), lParam = LPSIZE)
  DVPLUGINMSG_CLEAR         = DVPLUGINMSG_BASE + 27;	// Plugin should clear its display and free the current picture
  DVPLUGINMSG_NOTIFY_LOADPROGRESS = DVPLUGINMSG_BASE + 28;	// Posted from plugin back to owner to notify of load progress ( wParam = percent value complete )
  DVPLUGINMSG_ISDLGMESSAGE  = DVPLUGINMSG_BASE + 29;	// Plugin should return true if ( lParam = LPMSG ) is a message for one of its dialogs and it has handled it
  DVPLUGINMSG_TRANSLATEACCEL = DVPLUGINMSG_BASE + 30;	// Plugin should return true if ( lParam = LPMSG ) was handled by its accelerators
  DVPLUGINMSG_REINITIALIZE  = DVPLUGINMSG_BASE + 31;	// Plugin config has changed and viewer should reinitialize itself if necessary
  DVPLUGINMSG_SHOWHIDESCROLLBARS = DVPLUGINMSG_BASE + 32;	// wParam = BOOL indicating whether scrollbars should be shown or hidden

// Notification messages sent from a plugin to its parent window // corrected by ST
const
 DVPN_FIRST:    Integer   = Integer($FFFFFFFF - 2000 + 1);
 DVPN_LAST:	Integer    = Integer($FFFFFFFF - 2020 + 1);

 DVPN_GETBGCOL:     Integer = Integer($FFFFFFFF - 2000 + 1 - 0);        // Get background color (return value is a COLORREF)
 DVPN_SIZECHANGE:   Integer = Integer($FFFFFFFF - 2000 + 1 - 1);        // Image size has changed (DVPNMSIZECHANGE structure)
 DVPN_CLICK:	    Integer = Integer($FFFFFFFF - 2000 + 1 - 2);        // Mouse click (single left button click, DVPNMCLICK structure)
 DVPN_RESETZOOM:    Integer = Integer($FFFFFFFF - 2000 + 1 - 3);        // Reset zoom factor (zoom factor has had to be changed, DVPNMRESETZOOM structure)
 DVPN_LBUTTONSCROLL: Integer = Integer($FFFFFFFF - 2000 + 1 - 4);       // Get 'left button scroll' flag (return value is BOOL indicating whether left button should be used for scrolling)
 DVPN_CLEARED:	   Integer  = Integer($FFFFFFFF - 2000 + 1 - 5);        // Picture has been cleared (sent by plugin to tell parent that picture has been cleared from display)
 DVPN_FOCUSCHANGE:  Integer = Integer($FFFFFFFF - 2000 + 1 - 6);        // Focus has changed (DVPNMFOCUSCHANGE structure)
 DVPN_CAPABILITIES: Integer = Integer($FFFFFFFF - 2000 + 1 - 7);        // Capabilities flags have changed (DVPNMCAPABILITIES structure)
 DVPN_STATUSTEXT:   Integer = Integer($FFFFFFFF - 2000 + 1 - 8);        // Display status text (DVPNMSTATUSTEXT structure)
 DVPN_MCLICK:       Integer = Integer($FFFFFFFF - 2000 + 1 - 11);       // Middle button click, same as DVPN_CLICK
 DVPN_MOUSEWHEEL:   Integer = Integer($FFFFFFFF - 2000 + 1 - 15);       // Mouse wheel message (DVPNMMOUSEWHEEL structure) // added by ST

type
  TWMLoad = record
   { D1: Byte;
    D2: Byte;
    D3: Byte;
    D4: Byte;
    D5: Byte;
    D6: Byte;
    D7: Byte;
    D8: Byte;  }

    wParam: WORD;
    lParam: WORD;
    Result: Longint;

  end;

// Notification structure for DVPN_SIZECHANGE
type
  TtagDVPNMSIZECHANGE = record
	hdr: NMHDR;
	szSize: SIZE;
  end;

// Notification structure for DVPN_CLICK
type
  TtagDVPNMCLICK = record
	hdr: NMHDR;
	pt: TPOINT;
	fMenu: BOOL;
  end;

// Notification structure for DVPN_RESETZOOM
type
  TtagDVPNMRESETZOOM = record
	hdr: NMHDR;
	iZoom: Integer;
  end;

// Notification structure for DVPN_FOCUSCHANGE
type
  TtagDVPNMFOCUSCHANGE = record
	hdr: NMHDR;
	fGotFocus: BOOL;
  end;

// Notification structure for DVPN_CAPABILITIES
type
  TtagDVPNMCAPABILITIES = record
	hdr: NMHDR;
	dwCapabilities: DWORD;
  end;

// Notification structure for DVPN_STATUSTEXT
type
  TtagDVPNMSTATUSTEXT = record
    hdr: NMHDR;
    lpszStatusText: LPTSTR;
    fUnicode: BOOL;
  end;

// Notification structure for DVPN_MOUSEWHEEL // added by ST
type TtagDVPNMMOUSEWHEEL = record
    hdr: NMHDR;
    wParam: Longint;
    lParam: Longint;
  end;

// Zoom constants for DVPLUGINMSG_ZOOM
const
 ZOOM_ORIGINAL  = 0;
 ZOOM_FITPAGE	= -1;

// Viewer capability flags returned by DVPLUGINMSG_GETCAPABILITIES
const
 VPCAPABILITY_RESIZE_FIT		= $00000001;	// Can resize to fit page
 VPCAPABILITY_RESIZE_ANY		= $00000002;	// Can resize to any percentage
 VPCAPABILITY_ROTATE_RIGHTANGLE	= $00000004;	// Can rotate in steps of 90 degrees
 VPCAPABILITY_ROTATE_ANY		= $00000008;	// Can rotate to any angle
 VPCAPABILITY_SELECTALL			= $00000010;	// Can 'select all' for clipboard copy
 VPCAPABILITY_COPYALL			= $00000020;	// Can 'copy all' to clipboard
 VPCAPABILITY_COPYSELECTION		= $00000040;	// Can 'copy selection' to clipboard
 VPCAPABILITY_PRINT			    = $00000080;	// Can print
 VPCAPABILITY_WANTFOCUS			= $00000100;	// Viewer wants input focus
 VPCAPABILITY_SHOWPROPERTIES	= $00000200;	// Can show properties dialog
 VPCAPABILITY_WANTMOUSEWHEEL	= $00000400;	// Viewer wants to handle mouse wheel itself
 VPCAPABILITY_ADDCONTEXTMENU	= $00000800;	// Viewer can add context menu items
 VPCAPABILITY_HASDIALOGS		= $00001000;	// Viewer may have dialogs and wants DVPLUGINMSG_ISDLGMESSAGE messages
 VPCAPABILITY_HASACCELERATORS	= $00002000;	// Viewer may have accelerators and wants DVPLUGINMSG_TRANSLATEACCEL messages

// Structure used to add items to the context menu
type
  TDVPContextMenuItem = record
	lpszLabel: LPSTR;
    dwFlags: DWORD;
    uID: UINT;
  end;

// DVPCONTEXTMENUITEM flags
const
 DVPCMF_CHECKED				= $00000001;	// Item appears checked
 DVPCMF_RADIOCHECK			= $00000002;	// Checkmark uses a radio button
 DVPCMF_DISABLED			= $00000004;	// Item is disabled
 DVPCMF_SEPARATOR			= $00000010;	// Item is a separator
 DVPCMF_BEGINSUBMENU		= $00000020;	// Item is a submenu
 DVPCMF_ENDSUBMENU			= $00000040;	// Item is the last in a submenu

// Exported plugin DLL functions
const
 DVPFUNCNAME_IDENTIFYA			    = 'DVP_IdentifyA';
 DVPFUNCNAME_IDENTIFYW			    = 'DVP_IdentifyW';
 DVPFUNCNAME_IDENTIFYFILEA		    = 'DVP_IdentifyFileA';
 DVPFUNCNAME_IDENTIFYFILEW		    = 'DVP_IdentifyFileW';
 DVPFUNCNAME_IDENTIFYFILESTREAMA	= 'DVP_IdentifyFileStreamA';
 DVPFUNCNAME_IDENTIFYFILESTREAMW	= 'DVP_IdentifyFileStreamW';
 DVPFUNCNAME_IDENTIFYFILEBYTESA		= 'DVP_IdentifyFileBytesA';
 DVPFUNCNAME_IDENTIFYFILEBYTESW		= 'DVP_IdentifyFileBytesW';
 DVPFUNCNAME_LOADBITMAPA		    = 'DVP_LoadBitmapA';
 DVPFUNCNAME_LOADBITMAPW		    = 'DVP_LoadBitmapW';
 DVPFUNCNAME_LOADBITMAPSTREAMA		= 'DVP_LoadBitmapStreamA';
 DVPFUNCNAME_LOADBITMAPSTREAMW		= 'DVP_LoadBitmapStreamW';
 DVPFUNCNAME_SHOWPROPERTIESA		= 'DVP_ShowPropertiesA';
 DVPFUNCNAME_SHOWPROPERTIESW		= 'DVP_ShowPropertiesW';
 DVPFUNCNAME_SHOWPROPERTIESSTREAMA	= 'DVP_ShowPropertiesStreamA';
 DVPFUNCNAME_SHOWPROPERTIESSTREAMW	= 'DVP_ShowPropertiesStreamW';
 DVPFUNCNAME_CREATEVIEWER		    = 'DVP_CreateViewer';
 DVPFUNCNAME_CONFIGURE			    = 'DVP_Configure';
 DVPFUNCNAME_ABOUT			        = 'DVP_About';

// dwStreamFlags for the Stream functions
const
 DVPSF_Slow				= $00000001;    // Stream refers to 'slow' media
 DVPSF_NoRandomSeek		= $00000002;	// Stream does not support random seek (sequential only)

// Function prototypes
type
  t_DVP_Identify	= function(var InitInfo: TDOpusViewerPluginInfoW): Boolean; cdecl;
  t_DVP_IdentifyFile	= function(hWnd: HWND; lpszName: LPTSTR; lpVPFileInfo: TLPVIEWERPLUGINFILEINFOW; hAbortEvent: THANDLE): Boolean; cdecl;
  t_DVP_Configure	= function(hWndParent, hWndNotify: HWND; dwNotifyData: DWORD): HWND; cdecl;
  t_DVP_LoadBitmap	= function(hWnd: HWND; lpszName: LPTSTR; lpVPFileInfo: TLPVIEWERPLUGINFILEINFOW; lpszDesiredSize: TtagSIZE; hAbortEvent: THANDLE): HBITMAP; cdecl;
  t_DVP_CreateViewer	= function(hWndParent: HWND; lpRc: TRECT; dwFlags: DWORD): HWND; cdecl;
  t_DVP_ShowProperties	= function(hWndParent: HWND; lpszName: LPTSTR; lpVPFileInfo: TLPVIEWERPLUGINFILEINFOW): HWND; cdecl;
  t_DVP_About		= function(hWndParent: HWND): HWND; cdecl;
  t_DVP_IdentifyFileStream	= function(hWnd: HWND; lpStream: Pointer; lpszName: LPTSTR; lpVPFileInfo: TLPVIEWERPLUGINFILEINFOW; dwStreamFlags: DWORD): Boolean; cdecl;
  t_DVP_IdentifyFileBytes	= function(hWnd: HWND; lpszName: LPTSTR; lpData: PBYTE; uiDataSize: UINT; lpVPFileInfo: TLPVIEWERPLUGINFILEINFOW; dwStreamFlags: DWORD): Boolean; cdecl;
  t_DVP_LoadBitmapStream	= function(hWnd: HWND; lpStream: Pointer; lpszName: LPTSTR; lpVPFileInfo: TLPVIEWERPLUGINFILEINFOW; lpszDesiredSize: LPSIZE; dwStreamFlags: DWORD): HBITMAP; cdecl;
  t_DVP_ShowPropertiesStream	= function(hWndParent: HWND; lpStream: Pointer; lpszName: LPTSTR; lpVPFileInfo: TLPVIEWERPLUGINFILEINFOW; dwStreamFlags: DWORD): HWND; cdecl;

implementation

end.
